/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.TextEditorShell;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicButtonUI;
import net.nooj4nlp.controller.TextEditorShell.JMftPanel;
import net.nooj4nlp.controller.TextEditorShell.TextEditorShellController;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.TuGraph;
import net.nooj4nlp.gui.shells.TextEditorShell;

public class JMftPanelMouseAdapter
extends MouseAdapter {
    private TextEditorShellController textController;

    public JMftPanelMouseAdapter(TextEditorShellController textController) {
        this.textController = textController;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TuGraph tuGraph = this.textController.getTuGraph();
        if (tuGraph != null) {
            int y;
            TextEditorShell textShell = this.textController.getTextShell();
            JMftPanel mftPanel = textShell.getHiddenPanel();
            Double selectAllAnnotationsAtPosition = this.textController.getSelectAllAnnotationsAtPosition();
            RefObject<Double> refSelectAllAnnotationsAtPosition = new RefObject<Double>(selectAllAnnotationsAtPosition);
            int x = e.getX();
            if (tuGraph.getSelectedAnnotation(x, y = e.getY(), mftPanel, refSelectAllAnnotationsAtPosition)) {
                selectAllAnnotationsAtPosition = (Double)refSelectAllAnnotationsAtPosition.argvalue;
                tuGraph.computeXYcoord(mftPanel, selectAllAnnotationsAtPosition, y);
                JButton test = new JButton(Integer.toString(selectAllAnnotationsAtPosition.intValue()));
                test.setLocation(new Point(tuGraph.xCoord, 0));
                test.setUI(new BasicButtonUI(){

                    @Override
                    public void paint(Graphics g, JComponent component) {
                        int thicknessOfBorders = 3;
                        Graphics2D g2D = (Graphics2D)g;
                        JButton myButton = (JButton)component;
                        Font buttonFont = new Font(myButton.getFont().getName(), 1, myButton.getFont().getSize());
                        myButton.setFont(buttonFont);
                        myButton.setBorder(BorderFactory.createLineBorder(Color.RED, thicknessOfBorders));
                        g2D.setColor(Color.WHITE);
                        g2D.fillRoundRect(thicknessOfBorders, thicknessOfBorders, component.getWidth() - thicknessOfBorders, component.getHeight() - thicknessOfBorders, thicknessOfBorders, thicknessOfBorders);
                        super.paint(g2D, component);
                    }
                });
                test.setMinimumSize(new Dimension(60, 20));
                textShell.getHiddenPanel().removeAll();
                textShell.getHiddenPanel().add(test);
                JScrollPane scroll = textShell.getPanelScrollPane();
                scroll.getVerticalScrollBar().setValue(0);
                scroll.getHorizontalScrollBar().setValue(tuGraph.xCoord);
                textShell.getHiddenPanel().setSelectAllAnnotationsAtPosition(selectAllAnnotationsAtPosition);
                textShell.getTextPane().removeCaretListener(textShell.getUnitSelectionListener());
                int currentUnit = (Integer)textShell.getSpinner().getValue();
                Double newCaretPosition = selectAllAnnotationsAtPosition + (double)this.textController.getMyText().mft.tuAddresses[currentUnit];
                textShell.getTextPane().setCaretPosition(newCaretPosition.intValue());
                textShell.getTextPane().getCaret().setVisible(true);
                textShell.getTextPane().addCaretListener(textShell.getUnitSelectionListener());
                textShell.invalidate();
                textShell.validate();
                textShell.repaint();
            }
        }
    }
}

